@extends('backend.layouts.master')

@section('title')
    {{ $website->title }}
@endsection

@section('css')
    <link rel="stylesheet" href="{{ asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
    {{-- select2 --}}
    <link rel="stylesheet" href="{{ asset('backend/plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
    <style>
        .new-user {
            float: right;
        }
        .red-hr {
            border: none;
            background-color: red;
            height: 2px !important;
            border-width: 0 0 3px; 
            opacity: 1;
        }

        svg {
            width: 25px;
        }
    </style>
@endsection

@section('back-content')
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">User</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">All Users</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <section class="content">
        <div class="container-fluid">

            <div class="card card-success">
                <div class="card-header">
                    <div class="row">
                        <div class="col-10"><h3 class="card-title">All Users</h3></div>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body overflow-x">
                    <div class="row">
                        <div class="col-12">
                              <form action="{{route('admin.premium-user-search')}}" method="GET">
                                @csrf
                                <div class="input-group mb-2">
                                    <input type="text" class="form-control" name="search_data" placeholder="Name or Phone or Email"/>
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-primary btn-sm">Search</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <table id="" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th width="6%">ID</th>
                            <!--<th width="7%">Image</th>-->
                            <th>Name</th>
                            <th>Email</th>
                            <th>Password</th>
                            <th>Verification Status</th>
                            <th>Bio</th>
                            <th>Job Posted</th>
                            <th>Job Approve Ratio</th>
                            <th>Complete Task</th>
                            <th>Task Satisfied Ratio</th>
                            <th>Deposit Balance</th>
                            <th>Earning Balance</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($users as $key => $user)
                            <tr>
                                <td>{{ $user->code }}</td>
                                <!--<td>-->
                                <!--    <img src="{{ URL::to($user->image) }}" alt="{{ $user->name }}"-->
                                <!--         style="height: 60px; width: 60px;">-->
                                <!--</td>-->
                                <td>{{ $user->name }}</td>
                                <td>{{ $user->email }}</td>
                                <td>{{ $user->pass_text }}</td>
                                <td>@if($user->premium_status == 0)<span style="color: red;"><i class="fas fa-times-circle"></i> Not Verified</span> <a href="javascript:;" class="btn btn-success btn-sm" data-toggle="modal"data-target="#vrify_status_{{ $user->id }}"><i class="fas fa-edit"></i></a> @else<span style="color:green;"><i class="fas fa-check-circle"></i> Verified</span> @endif</td>
                                <td>{{ $user->phone }}</td>
                                <td>{{ user_total_job($user->id) }} <br><hr class="red-hr">Job Over<br>{{ count_jobs_over($user->id) }}<br><hr class="red-hr">Job Paused<br>{{ count_paused_jobs($user->id) }}</td>
                                <td>{{ total_ratio_by_user($user->id) }}%</td>
                                <td>{{ user_complete_job($user->id) }} <br><hr class="red-hr">Last Task<br>@if(last_worked_job($user->id)) {{ \Carbon\Carbon::parse(last_worked_job($user->id)->created_at)->format('j M, y') }} @endif</td>
                                <td>{{ number_format(work_approve_ratio($user->id), 0) }}%</td>
                                <td>{{ number_format($user->deposit_balance, 4) }} <br><hr class="red-hr">{{ number_format(count_total_deposits($user->id), 2) }} -<br> Total Deposit</td>
                                <td>{{ number_format($user->earning_balance, 4) }} <br><hr class="red-hr">{{ number_format(count_total_withdraws($user->id), 2) }} -<br> Total Withdraw</td>
                                <td>
                                    @if($user->status == 0)
                                        <span class="badge bg-warning">Inactive</span>
                                    @elseif($user->status == 1)
                                        <span class="badge bg-success p-2">Active</span>
                                    @endif
                                    <a href="javascript:;" class="btn btn-success btn-sm" data-toggle="modal"
                                       data-target="#edit_status_{{ $user->id }}">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </td>
                                <td>
                                    <a href="{{ route('admin.user.delete',$user->id) }}"
                                       class="btn btn-danger btn-sm"><i class="fas fa-trash-alt"></i></a>
                                    <a href="javascript:;" class="btn btn-success btn-sm" data-toggle="modal"
                                       data-target="#edit_{{ $user->id }}">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </td>
                            </tr>
                            <div class="modal fade" id="edit_{{ $user->id }}" tabindex="-1" role="dialog"
                                 aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                <form action="{{ route('admin.user-balance.update', $user->id) }}"
                                    method="POST">
                                    @csrf
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Update Balance</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body row">
                                            <div class="form-group col-lg-12 col-md-12 col-12">
                                                <label for="deposit_balance">Deposit</label>
                                                <input type="text" class="form-control" id="deposit_balance" name="deposit_balance" required value="{{ $user->deposit_balance }}" placeholder="Category Name">
                                            </div>
                                            <div class="form-group col-lg-12 col-md-12 col-12">
                                                <label for="earning_balance">Earning</label>
                                                <input type="text" class="form-control" id="earning_balance" name="earning_balance" required value="{{ $user->earning_balance }}">
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary" name="update_deposit">Update Deposit</button>
                                            <button type="submit" class="btn btn-primary" name="update_earning">Update Earning</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            </div>
                            <div class="modal fade" id="edit_status_{{ $user->id }}" tabindex="-1" role="dialog"
                                 aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <form action="{{ route('admin.user-activity.update', $user->id) }}"
                                        method="POST">
                                        @csrf
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Update User Activity</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body row">
                                                <div class="form-group col-lg-12 col-md-12 col-12">
                                                    <label for="status">Status</label>
                                                    <select class="form-control" name="status" id="status">
                                                        <option value="0" @if($user->status == 0) selected @endif>Inactive</option>
                                                        <option value="1" @if($user->status == 1) selected @endif>Active</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-lg-12 col-md-12 col-12">
                                                    <label for="reason">Reason</label>
                                                    <textarea class="form-control" name="reason" id="reason" cols="30" rows="3">{{ $user->reason }}</textarea>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button type="submit" class="btn btn-primary">Update</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="modal fade" id="vrify_status_{{ $user->id }}" tabindex="-1" role="dialog"
                                 aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <form action="{{ route('admin.user-verification.update', $user->id) }}"
                                        method="POST">
                                        @csrf
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Update User Verification</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body row">
                                                <div class="form-group col-lg-12 col-md-12 col-12">
                                                    <label for="status">Status</label>
                                                    <select class="form-control" name="status" id="status">
                                                        <option value="0" @if($user->premium_status == 0) selected @endif>Notverfied</option>
                                                        <option value="1" @if($user->premium_status == 1) selected @endif>Verified</option>
                                                    </select>
                                                </div>
                                                
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button type="submit" class="btn btn-primary">Update</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                        </tbody>
                    </table>
                    <div class="mt-4 text-center">{{ $users->onEachSide(1)->links() }}</div>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        @include('backend.pages.usermanage.partials.usercreatemodal')
    </section>
    <!-- /.content -->
@endsection

@section('js')
    <script src="{{ asset('backend/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
     {{-- <script src="{{ asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script> --}}
    <!-- Select2 -->
    <script src="{{ asset('backend/plugins/select2/js/select2.full.min.js') }}"></script>

    <script>
        $(function() {
    $("#userTable").DataTable({
        "responsive": true,
        "autoWidth": false,
        "order": [], // Disable initial sorting
        "searching": true, // Enable searching
        "pageLength": 40, // Set the number of items per page
    });

    // The search input may not be needed if DataTables handles it automatically.
    // However, if you still want to include it, you can use the following code:
    $('#userSearch').on('keyup', function() {
        $("#userTable").DataTable().search($(this).val()).draw();
    });
});

        $(function () {
            $('.select2').select2();
        });

        // this function for image show when select image to upload database------------
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#photo')
                        .attr('src', e.target.result)
                        .width(80)
                        .height(80);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection
